<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us - Bureau of Cybercrime Intelligence</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/styles.css">
    <style>
       
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-custom fixed-top">
        <div class="container">
            <a class="navbar-brand navbar-brand-custom d-flex align-items-center" href="index">
                <span class="logo-accent me-3"><img src="images/logo.png" alt="BCI LOGO" width="80" height="80"></span>
                <h3 class="mb-0">Bureau of Cybercrime <br>Intelligence</h3>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon text-white">
                    <i class="bi bi-list"></i>
                </span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="index">Home</a></li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="services">Services</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom active" href="about">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="cyber-threats">Cyber Threats</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="contact">Contact</a>
                    </li>
                    <li class="nav-item ms-2">
                        <a href="report-cybercrime" class="btn btn-report-nav">
                            <i class="bi bi-exclamation-triangle-fill me-1"></i> Report CyberCrime
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="page-hero">
        <div class="container text-center">
            <h1>About BCI</h1>
            <p>Leading the fight against cybercrime through intelligence and innovation</p>
        </div>
    </section>

    <!-- About Content Section -->
    <section class="about-content-section">
        <div class="container">
            <!-- Introduction -->
            <div class="about-intro">
                <h2>Our Mission</h2>
                <p>The Bureau of Cybercrime Intelligence (BCI) is dedicated to defending digital intelligence and protecting organizations from evolving cyber threats. We combine advanced technology with expert human analysis to provide comprehensive cybersecurity solutions.</p>
            </div>

            <!-- Mission & Vision -->
            <div class="mission-vision">
                <div class="mission-card">
                    <i class="bi bi-bullseye"></i>
                    <h3>Our Mission</h3>
                    <p>To provide world-class cybercrime intelligence and forensic services that protect digital assets, ensure business continuity, and bring cybercriminals to justice.</p>
                </div>
                <div class="vision-card">
                    <i class="bi bi-eye"></i>
                    <h3>Our Vision</h3>
                    <p>A safer digital world where organizations can operate securely, confident in their cyber defenses and resilience against emerging threats.</p>
                </div>
            </div>

            <!-- Core Values -->
            <div class="values-section">
                <h2>Our Core Values</h2>
                <div class="values-grid">
                    <div class="value-card">
                        <i class="bi bi-shield-check"></i>
                        <h3>Integrity</h3>
                        <p>We maintain the highest ethical standards in all our investigations and interactions.</p>
                    </div>
                    <div class="value-card">
                        <i class="bi bi-lightbulb"></i>
                        <h3>Innovation</h3>
                        <p>Continuously developing new techniques to stay ahead of evolving cyber threats.</p>
                    </div>
                    <div class="value-card">
                        <i class="bi bi-people"></i>
                        <h3>Collaboration</h3>
                        <p>Working closely with clients, law enforcement, and industry partners.</p>
                    </div>
                    <div class="value-card">
                        <i class="bi bi-award"></i>
                        <h3>Excellence</h3>
                        <p>Commitment to delivering exceptional results and continuous improvement.</p>
                    </div>
                </div>
            </div>

            <!-- Expert Team -->
            <div class="team-section">
                <!-- <h2>Our Expert Team</h2> -->
                <h2>Our Experience</h2>
                <p>Our team consists of cybersecurity veterans with decades of combined experience in:</p>
                <div class="expertise-grid">
                    <div class="expertise-item">
                        <i class="bi bi-search"></i>
                        <span>Digital Forensics</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-diagram-3"></i>
                        <span>Network Security</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-bug"></i>
                        <span>Malware Analysis</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-shield-lock"></i>
                        <span>Cyber Law</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-graph-up"></i>
                        <span>Threat Intelligence</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-phone"></i>
                        <span>Mobile Security</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-incognito"></i>
                        <span>Dark Web Investigations</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-shield-exclamation"></i>
                        <span>Vulnerability Assessment</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-cloud-lightning"></i>
                        <span>Cloud Security</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-lock-fill"></i>
                        <span>Incident Response</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-eye-fill"></i>
                        <span>Fraud Detection</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-exclamation-triangle"></i>
                        <span>Risk Management</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-arrow-repeat"></i>
                        <span>Incident Handling</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-check-circle"></i>
                        <span>Security Auditing</span>
                    </div>
                    <div class="expertise-item">
                        <i class="bi bi-shield-lock"></i>
                        <span>Data Protection</span>
                    </div>
                </div>
            </div>

            <!-- Achievements -->
            <div class="achievements">
                <h2>Our Achievements</h2>
                <div class="stats-grid">
                    <div class="stat-item">
                        <h3>5000+</h3>
                        <p>Incidents Investigated</p>
                    </div>
                    <div class="stat-item">
                        <h3>98%</h3>
                        <p>Successful Resolution Rate</p>
                    </div>
                    <div class="stat-item">
                        <h3>250+</h3>
                        <p>Cybercriminal Networks Disrupted</p>
                    </div>
                    <div class="stat-item">
                        <h3>24/7</h3>
                        <p>Emergency Response</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center">
            <h2 class="cta-title">Partner with BCI</h2>
            <p class="mb-4" style="opacity: 1; color: white;">Join us in creating a safer digital environment</p>
            <a href="contact" class="btn btn-cta">
                <i class="bi bi-person-plus-fill me-2"></i> Get in Touch
            </a>
        </div>
    </section>

 <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row g-4">
                <!-- Logo and Description -->
                <div class="col-lg-4">
                    <div class="footer-brand d-flex align-items-center mb-4">
                        <a  href="index" class="logo-accent me-3">
                            <img src="images/logo.png" alt="BCI LOGO" width="80" height="80">
                        </a>
                        <div>
                            <h4 class="mb-1 fw-bold text-white">BUREAU OF</h4>
                            <h4 class="mb-0 fw-bold text-white">CYBERCRIME INTELLIGENCE</h4>
                        </div>
                    </div>
                    <p class="text-light mb-4" style="opacity: 0.8;">
                        Defending Digital Intelligence through advanced cybercrime investigation and prevention.
                    </p>
                    <div class="social-links d-flex gap-3">
                        <a href="#" class="social-icon"><i class="bi bi-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-linkedin"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-facebook"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-youtube"></i></a>
                    </div>
                </div>
                
                <!-- Quick Links -->
                <div class="col-lg-2 col-md-6">
                    <h5 class="footer-heading">Quick Links</h5>
                    <ul class="footer-links">
                        <li><a href="index"><i class="bi bi-house-door me-2"></i> Home</a></li>
                        <li><a href="services"><i class="bi bi-gear me-2"></i> Services</a></li>
                        <li><a href="about"><i class="bi bi-info-circle me-2"></i> About</a></li>
                        <li><a href="cyber-threats"><i class="bi bi-shield-exclamation me-2"></i> Cyber Threats</a></li>
                        <li><a href="contact"><i class="bi bi-envelope me-2"></i> Contact</a></li>
                    </ul>
                </div>
                
                <!-- Contact Information -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-heading">Contact Information</h5>
                    <div class="contact-info">
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-telephone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">General Inquiries</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4711</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-phone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Emergency Hotline</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4712</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-envelope-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Email Address</h6>
                                <p class="mb-0 text-light">cybercrimeintelbureau@gmail.com</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start">
                            <i class="bi bi-clock-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Operating Hours</h6>
                                <p class="mb-0 text-light">24/7 Emergency Response</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Newsletter & Emergency -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-heading">Stay Updated</h5>
                    <div class="newsletter mb-4">
                        <p class="text-light mb-3" style="opacity: 0.8;">
                            Subscribe to our threat intelligence newsletter
                        </p>
                        <div class="input-group">
                            <input type="email" class="form-control" placeholder="Your email">
                            <button class="btn btn-warning" type="button">
                                <i class="bi bi-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="emergency-card bg-dark border border-warning rounded p-3">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-exclamation-triangle-fill text-warning fs-4 me-2"></i>
                            <h6 class="mb-0 text-white">Emergency Contact</h6>
                        </div>
                        <p class="text-light small mb-3">For immediate cyber incident response</p>
                        <a href="report-cybercrime" class="btn btn-warning w-100">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i> Report Emergency
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Footer Bottom -->
            <div class="footer-bottom mt-5 pt-4 border-top border-secondary">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <p class="mb-2 mb-md-0 text-light" style="opacity: 0.7;">
                            &copy; 2026 Bureau of Cybercrime Intelligence. All rights reserved.
                        </p>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <div class="footer-bottom-links">
                            <a href="privacy-policy" class="text-light me-3" style="opacity: 0.7;">Privacy Policy</a>
                            <a href="terms-of-service" class="text-light me-3" style="opacity: 0.7;">Terms of Service</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Back to Top Button -->
    <button id="backToTop" class="btn-back-to-top">
        <i class="bi bi-chevron-up"></i>
    </button>

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script src="js/main.js"></script>
    
    <script>
        // Back to Top Button
        const backToTopButton = document.getElementById('backToTop');

        window.addEventListener('scroll', function() {
            if (window.scrollY > 300) {
                backToTopButton.classList.add('visible');
            } else {
                backToTopButton.classList.remove('visible');
            }
        });

        backToTopButton.addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });

        // Animated counters for stats
        const animateCounter = (element) => {
            const target = parseInt(element.getAttribute('data-target'));
            const duration = 2000;
            const increment = target / (duration / 16);
            let current = 0;
            
            const timer = setInterval(() => {
                current += increment;
                if (current >= target) {
                    element.textContent = target;
                    clearInterval(timer);
                } else {
                    element.textContent = Math.floor(current);
                }
            }, 16);
        };

        // Add active class to current page in navigation
        document.addEventListener('DOMContentLoaded', function() {
            const currentPage = window.location.pathname.split('/').pop() || 'about.php';
            const navLinks = document.querySelectorAll('.nav-link-custom');
            
            navLinks.forEach(link => {
                const linkPage = link.getAttribute('href');
                if (linkPage === currentPage || 
                    (currentPage === '' && linkPage === 'about') ||
                    (currentPage === 'about.php' && linkPage === 'about')) {
                    link.classList.add('active');
                }
            });
            
            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    const targetId = this.getAttribute('href');
                    if (targetId === '#') return;
                    
                    const targetElement = document.querySelector(targetId);
                    if (targetElement) {
                        window.scrollTo({
                            top: targetElement.offsetTop - 80,
                            behavior: 'smooth'
                        });
                    }
                });
            });
            
            // Navbar background on scroll
            window.addEventListener('scroll', function() {
                const navbar = document.querySelector('.navbar-custom');
                if (window.scrollY > 50) {
                    navbar.style.backgroundColor = 'rgba(19, 27, 48, 0.95)';
                    navbar.style.backdropFilter = 'blur(10px)';
                } else {
                    navbar.style.backgroundColor = '';
                    navbar.style.backdropFilter = '';
                }
            });
        });
    </script>
</body>
</html>
