<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Careers - Bureau of Cybercrime Intelligence</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="css/styles.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-custom fixed-top">
        <div class="container">
            <a class="navbar-brand navbar-brand-custom d-flex align-items-center" href="index">
                <span class="logo-accent me-3"><img src="images/logo.png" alt="BCI LOGO" width="80" height="80"></span>
                <h3 class="mb-0">Bureau of Cybercrime <br>Intelligence</h3>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon text-white"><i class="bi bi-list"></i></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="index">Home</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="services">Services</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="about">About</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="cyber-threats">Cyber Threats</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="contact">Contact</a></li>
                    <li class="nav-item ms-2">
                        <a href="report-cybercrime" class="btn btn-report-nav">
                            <i class="bi bi-exclamation-triangle-fill me-1"></i> Report CyberCrime
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <section class="page-hero">
        <div class="container text-center">
            <h1>Join Our Team</h1>
            <p>Defend digital intelligence alongside elite cybersecurity professionals</p>
        </div>
    </section>

    <!-- Mission Statement -->
    <section class="careers-mission">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10 text-center">
                    <h2 class="mb-4">Work That Matters</h2>
                    <p class="lead">At BCI, you'll be part of a mission-driven team protecting organizations from sophisticated cyber threats. We combine cutting-edge technology with human expertise to investigate cybercrime, prevent attacks, and bring criminals to justice.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Join BCI -->
    <section class="why-join-section">
        <div class="container">
            <h2 class="section-title text-center mb-5">Why Join BCI</h2>
            <div class="row g-4">
                <div class="col-md-6 col-lg-3">
                    <div class="benefit-card">
                        <i class="bi bi-trophy-fill"></i>
                        <h4>Elite Training</h4>
                        <p>World-class training in digital forensics, threat intelligence, and incident response</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="benefit-card">
                        <i class="bi bi-globe"></i>
                        <h4>Global Impact</h4>
                        <p>Work on high-profile cases affecting organizations worldwide</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="benefit-card">
                        <i class="bi bi-people-fill"></i>
                        <h4>Expert Team</h4>
                        <p>Collaborate with top professionals in cybersecurity and law enforcement</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="benefit-card">
                        <i class="bi bi-bar-chart-fill"></i>
                        <h4>Career Growth</h4>
                        <p>Clear advancement paths and continuous learning opportunities</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Open Positions -->
    <section class="positions-section">
        <div class="container">
            <h2 class="section-title text-center mb-5">Open Positions</h2>
            
            <!-- Position 1 -->
            <div class="position-card">
                <div class="position-header">
                    <div>
                        <h3>Senior Cyber Threat Intelligence Analyst</h3>
                        <div class="position-meta">
                            <span><i class="bi bi-geo-alt-fill"></i> Monrovia, Liberia</span>
                            <span><i class="bi bi-briefcase-fill"></i> Full-time</span>
                            <span><i class="bi bi-clock-fill"></i> Posted 3 days ago</span>
                        </div>
                    </div>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#applyModal">Apply Now</button>
                </div>
                <div class="position-body">
                    <h5>Overview</h5>
                    <p>Lead threat intelligence operations tracking advanced persistent threats (APTs), nation-state actors, and organized cybercrime groups.</p>
                    
                    <h5>Requirements</h5>
                    <ul>
                        <li>5+ years in cyber threat intelligence or incident response</li>
                        <li>Deep understanding of threat actor TTPs and MITRE ATT&CK framework</li>
                        <li>Experience with OSINT, dark web monitoring, and malware analysis</li>
                        <li>Proficiency in Python, YARA, Sigma, and threat intelligence platforms</li>
                        <li>Relevant certifications (GCTI, GCFA, GREM preferred)</li>
                    </ul>
                    
                    <h5>Responsibilities</h5>
                    <ul>
                        <li>Track and profile threat actors and campaign activity</li>
                        <li>Produce actionable intelligence reports for clients</li>
                        <li>Develop detection rules and threat hunting queries</li>
                        <li>Collaborate with law enforcement on takedown operations</li>
                    </ul>
                </div>
            </div>

            <!-- Position 2 -->
            <div class="position-card">
                <div class="position-header">
                    <div>
                        <h3>Digital Forensics Investigator</h3>
                        <div class="position-meta">
                            <span><i class="bi bi-geo-alt-fill"></i> Monrovia, Liberia</span>
                            <span><i class="bi bi-briefcase-fill"></i> Full-time</span>
                            <span><i class="bi bi-clock-fill"></i> Posted 1 week ago</span>
                        </div>
                    </div>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#applyModal">Apply Now</button>
                </div>
                <div class="position-body">
                    <h5>Overview</h5>
                    <p>Conduct forensic examinations of digital evidence in support of cybercrime investigations and legal proceedings.</p>
                    
                    <h5>Requirements</h5>
                    <ul>
                        <li>3+ years in digital forensics (computer, mobile, cloud)</li>
                        <li>Expert knowledge of forensic tools (EnCase, FTK, X-Ways, Cellebrite)</li>
                        <li>Understanding of file systems, memory analysis, and artifact recovery</li>
                        <li>Experience testifying as expert witness</li>
                        <li>Certifications: GCFE, EnCE, or CCE required</li>
                    </ul>
                </div>
            </div>

            <!-- Position 3 -->
            <div class="position-card">
                <div class="position-header">
                    <div>
                        <h3>Incident Response Team Lead</h3>
                        <div class="position-meta">
                            <span><i class="bi bi-geo-alt-fill"></i> Monrovia, Liberia</span>
                            <span><i class="bi bi-briefcase-fill"></i> Full-time</span>
                            <span><i class="bi bi-clock-fill"></i> Posted 2 weeks ago</span>
                        </div>
                    </div>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#applyModal">Apply Now</button>
                </div>
                <div class="position-body">
                    <h5>Overview</h5>
                    <p>Lead rapid response to active cyber attacks including ransomware, data breaches, and APT intrusions.</p>
                    
                    <h5>Requirements</h5>
                    <ul>
                        <li>7+ years in incident response and cybersecurity</li>
                        <li>Proven leadership in managing IR engagements</li>
                        <li>Expertise in malware analysis, memory forensics, and network forensics</li>
                        <li>Strong communication skills for client and executive briefings</li>
                        <li>GCIH, GCIA, CISSP, or equivalent certifications</li>
                    </ul>
                </div>
            </div>

            <!-- Position 4 -->
            <div class="position-card">
                <div class="position-header">
                    <div>
                        <h3>Malware Reverse Engineer</h3>
                        <div class="position-meta">
                            <span><i class="bi bi-geo-alt-fill"></i> Remote / Monrovia</span>
                            <span><i class="bi bi-briefcase-fill"></i> Full-time</span>
                            <span><i class="bi bi-clock-fill"></i> Posted 4 days ago</span>
                        </div>
                    </div>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#applyModal">Apply Now</button>
                </div>
                <div class="position-body">
                    <h5>Overview</h5>
                    <p>Perform in-depth static and dynamic analysis of malware samples to understand capabilities, attribution, and develop countermeasures.</p>
                    
                    <h5>Requirements</h5>
                    <ul>
                        <li>Strong assembly language skills (x86, x64, ARM)</li>
                        <li>Proficiency with IDA Pro, Ghidra, debuggers, and sandboxes</li>
                        <li>Understanding of Windows internals, PE format, and obfuscation techniques</li>
                        <li>Experience analyzing ransomware, APT malware, or exploits</li>
                        <li>GREM certification preferred</li>
                    </ul>
                </div>
            </div>

            <!-- Position 5 -->
            <div class="position-card">
                <div class="position-header">
                    <div>
                        <h3>Cybersecurity Analyst (Entry Level)</h3>
                        <div class="position-meta">
                            <span><i class="bi bi-geo-alt-fill"></i> Monrovia, Liberia</span>
                            <span><i class="bi bi-briefcase-fill"></i> Full-time</span>
                            <span><i class="bi bi-clock-fill"></i> Posted 5 days ago</span>
                        </div>
                    </div>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#applyModal">Apply Now</button>
                </div>
                <div class="position-body">
                    <h5>Overview</h5>
                    <p>Join our team as a junior analyst supporting cybercrime investigations and threat monitoring operations.</p>
                    
                    <h5>Requirements</h5>
                    <ul>
                        <li>Bachelor's degree in Computer Science, Cybersecurity, or related field</li>
                        <li>Understanding of networking, operating systems, and security concepts</li>
                        <li>Basic knowledge of scripting (Python, PowerShell)</li>
                        <li>Security+ or equivalent certification</li>
                        <li>Strong analytical and problem-solving skills</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- Benefits -->
    <section class="benefits-section">
        <div class="container">
            <h2 class="section-title text-center mb-5">Comprehensive Benefits</h2>
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="benefit-detail">
                        <i class="bi bi-heart-pulse-fill"></i>
                        <h4>Health & Wellness</h4>
                        <ul>
                            <li>Premium health insurance</li>
                            <li>Dental and vision coverage</li>
                            <li>Mental health support</li>
                            <li>Wellness programs</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="benefit-detail">
                        <i class="bi bi-piggy-bank-fill"></i>
                        <h4>Financial Security</h4>
                        <ul>
                            <li>Competitive salary</li>
                            <li>Retirement plans (401k)</li>
                            <li>Performance bonuses</li>
                            <li>Stock options</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="benefit-detail">
                        <i class="bi bi-book-fill"></i>
                        <h4>Professional Development</h4>
                        <ul>
                            <li>Certification reimbursement</li>
                            <li>Conference attendance</li>
                            <li>Training programs</li>
                            <li>Tuition assistance</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="benefit-detail">
                        <i class="bi bi-calendar-check-fill"></i>
                        <h4>Time Off</h4>
                        <ul>
                            <li>Generous PTO policy</li>
                            <li>Paid holidays</li>
                            <li>Parental leave</li>
                            <li>Sabbatical options</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="benefit-detail">
                        <i class="bi bi-house-fill"></i>
                        <h4>Work-Life Balance</h4>
                        <ul>
                            <li>Flexible schedules</li>
                            <li>Remote work options</li>
                            <li>Modern workspaces</li>
                            <li>Relocation assistance</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="benefit-detail">
                        <i class="bi bi-shield-check"></i>
                        <h4>Additional Perks</h4>
                        <ul>
                            <li>Latest technology</li>
                            <li>Security clearances</li>
                            <li>Team events</li>
                            <li>Community impact</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Application Modal -->
    <div class="modal fade" id="applyModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Application Form</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="applicationForm">
                        <div class="mb-3">
                            <label class="form-label">Full Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Email <span class="text-danger">*</span></label>
                            <input type="email" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Phone <span class="text-danger">*</span></label>
                            <input type="tel" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Position Applying For <span class="text-danger">*</span></label>
                            <select class="form-select" required>
                                <option value="">Select position</option>
                                <option>Senior Cyber Threat Intelligence Analyst</option>
                                <option>Digital Forensics Investigator</option>
                                <option>Incident Response Team Lead</option>
                                <option>Malware Reverse Engineer</option>
                                <option>Cybersecurity Analyst (Entry Level)</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Resume/CV <span class="text-danger">*</span></label>
                            <input type="file" class="form-control" required accept=".pdf,.doc,.docx">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Cover Letter</label>
                            <textarea class="form-control" rows="4"></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">LinkedIn Profile</label>
                            <input type="url" class="form-control" placeholder="https://linkedin.com/in/yourprofile">
                        </div>
                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" id="consent" required>
                            <label class="form-check-label" for="consent">
                                I agree to background checks and security clearance processes
                            </label>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" onclick="submitApplication()">Submit Application</button>
                </div>
            </div>
        </div>
    </div>

    <!-- CTA -->
    <section class="cta-section">
        <div class="container text-center">
            <h2 class="cta-title">Ready to Make a Difference?</h2>
            <p class="mb-4" style="opacity: 1; color: white;">Join the fight against cybercrime</p>
            <a href="mailto:careers@bci.com" class="btn btn-cta">
                <i class="bi bi-envelope-fill me-2"></i> Contact Recruiting Team
            </a>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <div class="footer-bottom pt-4">
                <p class="mb-0 text-light text-center" style="opacity: 0.7;">
                    &copy; 2026 Bureau of Cybercrime Intelligence. All rights reserved.
                </p>
            </div>
        </div>
    </footer>

    <button id="backToTop" class="btn-back-to-top">
        <i class="bi bi-chevron-up"></i>
    </button>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="js/main.js"></script>
    <script>
        function submitApplication() {
            alert('Thank you for your application! Our recruiting team will review your submission and contact you within 5-7 business days. Application ID: BCI-CAREER-' + Date.now().toString().substring(8));
            document.getElementById('applicationForm').reset();
            bootstrap.Modal.getInstance(document.getElementById('applyModal')).hide();
        }
    </script>
</body>
</html>