<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us - Bureau of Cybercrime Intelligence</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="css/styles.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-custom fixed-top">
        <div class="container">
            <a class="navbar-brand navbar-brand-custom d-flex align-items-center" href="index">
                <span class="logo-accent me-3"><img src="images/logo.png" alt="BCI LOGO" width="80" height="80"></span>
                <h3 class="mb-0">Bureau of Cybercrime <br>Intelligence</h3>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon text-white">
                    <i class="bi bi-list"></i>
                </span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="index">Home</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="services">Services</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="about">About</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="cyber-threats">Cyber Threats</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom active" href="contact">Contact</a></li>
                    <li class="nav-item ms-2">
                        <a href="report-cybercrime" class="btn btn-report-nav">
                            <i class="bi bi-exclamation-triangle-fill me-1"></i> Report CyberCrime
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="page-hero">
        <div class="container text-center">
            <h1>Contact Bureau of Cybercrime Intelligence</h1>
            <p>Secure communication channels for cybercrime reporting and inquiries</p>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="contact-section">
        <div class="container py-5">
            <!-- Contact Form and Info Section -->
            <div class="row g-4 mb-5">
                <!-- Contact Form -->
                <div class="col-lg-7 col-md-12">
                    <div class="contact-form-card">
                        <div class="form-header">
                            <i class="bi bi-shield-lock-fill"></i>
                            <h2>Secure Contact Form</h2>
                            <p class="text-muted">All communications are encrypted and monitored for security</p>
                        </div>
                        
                        <form id="contactForm" class="needs-validation" novalidate>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Full Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Organization</label>
                                    <input type="text" class="form-control">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Email Address <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Phone Number</label>
                                    <input type="tel" class="form-control">
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Subject <span class="text-danger">*</span></label>
                                    <select class="form-select" required>
                                        <option value="">Select a subject</option>
                                        <option>General Inquiry</option>
                                        <option>Partnership Opportunity</option>
                                        <option>Media Request</option>
                                        <option>Technical Support</option>
                                        <option>Training & Certification</option>
                                        <option>Other</option>
                                    </select>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Message <span class="text-danger">*</span></label>
                                    <textarea class="form-control" rows="6" required></textarea>
                                </div>
                                <div class="col-12">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="privacy" required>
                                        <label class="form-check-label" for="privacy">
                                            I agree to the <a href="privacy-policy">Privacy Policy</a> and <a href="terms-of-service">Terms of Service</a>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg w-100">
                                        <i class="bi bi-send-fill me-2"></i> Send Secure Message
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Quick Contact Info -->
                <div class="col-lg-5 col-md-12">
                    <!-- Emergency Contact -->
                    <div class="contact-info-card emergency-contact mb-4">
                        <i class="bi bi-exclamation-triangle-fill"></i>
                        <h3>Emergency Incident Response</h3>
                        <p>Active cyber attack or data breach?</p>
                        <a href="report-cybercrime" class="btn btn-danger w-100 mb-3">
                            <i class="bi bi-telephone-fill me-2"></i> Report Now
                        </a>
                        <div class="hotline">
                            <i class="bi bi-phone-vibrate"></i>
                            <span>24/7 Hotline: +231 (90) 909 4712</span>
                        </div>
                    </div>

                    <!-- General Contact -->
                    <!-- <div class="contact-info-card">
                        <h4><i class="bi bi-building me-2"></i> Headquarters</h4>
                        <p class="mb-3">123 Cyber Security Boulevard<br>Intelligence District<br>Monrovia, Liberia</p>
                        
                        <h4><i class="bi bi-telephone me-2"></i> Phone</h4>
                        <p class="mb-3">General: +231 (90) 909 4711<br>Emergency: +231 (90) 909 4712</p>
                        
                        <h4><i class="bi bi-envelope me-2"></i> Email</h4>
                        <p class="mb-3">General: contact@bci.com<br>Media: media@bci.com<br>Careers: careers@bci.com</p>
                        
                        <h4><i class="bi bi-clock me-2"></i> Operating Hours</h4>
                        <p>24/7 Emergency Response<br>Mon-Fri: 8:00 AM - 6:00 PM<br>Sat-Sun: Emergency Only</p>
                    </div> -->
                </div>
            </div>

            <!-- Regional Offices Section -->
            <div class="row g-4">
                <div class="col-12">
                    <h2 class="section-title mb-4">Useful Information</h2>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="contact-info-card">
                        <h4><i class="bi bi-building me-2"></i>Phone</h4>
                        <p>Emergency: <br><strong>+231 (90) 909 4711</strong></p>
                        <small class="text-muted">General: +231 (90) 909 4712</small>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="contact-info-card">
                        <h4><i class="bi bi-envelope me-2"></i> Email</h4>
                        <p>General: <br><strong>contact@bci.com</strong></p>
                        <small class="text-muted">Media: media@bci.com</small>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="contact-info-card">
                        <h4><i class="bi bi-clock me-2"></i> Operating Hours</h4>
                        <p>24/7 Emergency Response<br>Mon-Fri: 8:00 AM - 6:00 PM<br>Sat-Sun: Emergency Only</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    < <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row g-4">
                <!-- Logo and Description -->
                <div class="col-lg-4">
                    <div class="footer-brand d-flex align-items-center mb-4">
                        <a  href="index" class="logo-accent me-3">
                            <img src="images/logo.png" alt="BCI LOGO" width="80" height="80">
                        </a>
                        <div>
                            <h4 class="mb-1 fw-bold text-white">BUREAU OF</h4>
                            <h4 class="mb-0 fw-bold text-white">CYBERCRIME INTELLIGENCE</h4>
                        </div>
                    </div>
                    <p class="text-light mb-4" style="opacity: 0.8;">
                        Defending Digital Intelligence through advanced cybercrime investigation and prevention.
                    </p>
                    <div class="social-links d-flex gap-3">
                        <a href="#" class="social-icon"><i class="bi bi-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-linkedin"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-facebook"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-youtube"></i></a>
                    </div>
                </div>
                
                <!-- Quick Links -->
                <div class="col-lg-2 col-md-6">
                    <h5 class="footer-heading">Quick Links</h5>
                    <ul class="footer-links">
                        <li><a href="home"><i class="bi bi-house-door me-2"></i> Home</a></li>
                        <li><a href="services"><i class="bi bi-gear me-2"></i> Services</a></li>
                        <li><a href="about"><i class="bi bi-info-circle me-2"></i> About</a></li>
                        <li><a href="cyber-threats"><i class="bi bi-shield-exclamation me-2"></i> Cyber Threats</a></li>
                        <li><a href="contact"><i class="bi bi-envelope me-2"></i> Contact</a></li>
                    </ul>
                </div>
                
                <!-- Contact Information -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-heading">Contact Information</h5>
                    <div class="contact-info">
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-telephone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">General Inquiries</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4711</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-phone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Emergency Hotline</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4712</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-envelope-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Email Address</h6>
                                <p class="mb-0 text-light">cybercrimeintelbureau@gmail.com</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start">
                            <i class="bi bi-clock-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Operating Hours</h6>
                                <p class="mb-0 text-light">24/7 Emergency Response</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Newsletter & Emergency -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-heading">Stay Updated</h5>
                    <div class="newsletter mb-4">
                        <p class="text-light mb-3" style="opacity: 0.8;">
                            Subscribe to our threat intelligence newsletter
                        </p>
                        <div class="input-group">
                            <input type="email" class="form-control" placeholder="Your email">
                            <button class="btn btn-warning" type="button">
                                <i class="bi bi-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="emergency-card bg-dark border border-warning rounded p-3">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-exclamation-triangle-fill text-warning fs-4 me-2"></i>
                            <h6 class="mb-0 text-white">Emergency Contact</h6>
                        </div>
                        <p class="text-light small mb-3">For immediate cyber incident response</p>
                        <a href="report-cybercrime" class="btn btn-warning w-100">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i> Report Emergency
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Footer Bottom -->
            <div class="footer-bottom mt-5 pt-4 border-top border-secondary">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <p class="mb-2 mb-md-0 text-light" style="opacity: 0.7;">
                            &copy; 2026 Bureau of Cybercrime Intelligence. All rights reserved.
                        </p>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <div class="footer-bottom-links">
                            <a href="privacy-policy" class="text-light me-3" style="opacity: 0.7;">Privacy Policy</a>
                            <a href="terms-of-service" class="text-light me-3" style="opacity: 0.7;">Terms of Service</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Back to Top Button -->
    <button id="backToTop" class="btn-back-to-top">
        <i class="bi bi-chevron-up"></i>
    </button>

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script src="js/main.js"></script>
    
    <script>
        // Back to Top Button
        const backToTopButton = document.getElementById('backToTop');

        window.addEventListener('scroll', function() {
            if (window.scrollY > 300) {
                backToTopButton.classList.add('visible');
            } else {
                backToTopButton.classList.remove('visible');
            }
        });

        backToTopButton.addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });

        // Animated counters for stats
        const animateCounter = (element) => {
            const target = parseInt(element.getAttribute('data-target'));
            const duration = 2000;
            const increment = target / (duration / 16);
            let current = 0;
            
            const timer = setInterval(() => {
                current += increment;
                if (current >= target) {
                    element.textContent = target;
                    clearInterval(timer);
                } else {
                    element.textContent = Math.floor(current);
                }
            }, 16);
        };

        // Add active class to current page in navigation
        document.addEventListener('DOMContentLoaded', function() {
            const currentPage = window.location.pathname.split('/').pop() || 'contact.php';
            const navLinks = document.querySelectorAll('.nav-link-custom');
            
            navLinks.forEach(link => {
                const linkPage = link.getAttribute('href');
                if (linkPage === currentPage || 
                    (currentPage === '' && linkPage === 'contact') ||
                    (currentPage === 'contact.php' && linkPage === 'contact')) {
                    link.classList.add('active');
                }
            });
            
            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    const targetId = this.getAttribute('href');
                    if (targetId === '#') return;
                    
                    const targetElement = document.querySelector(targetId);
                    if (targetElement) {
                        window.scrollTo({
                            top: targetElement.offsetTop - 80,
                            behavior: 'smooth'
                        });
                    }
                });
            });
            
            // Navbar background on scroll
            window.addEventListener('scroll', function() {
                const navbar = document.querySelector('.navbar-custom');
                if (window.scrollY > 50) {
                    navbar.style.backgroundColor = 'rgba(19, 27, 48, 0.95)';
                    navbar.style.backdropFilter = 'blur(10px)';
                } else {
                    navbar.style.backgroundColor = '';
                    navbar.style.backdropFilter = '';
                }
            });
        });
    </script>
    
    <script>
        document.getElementById('contactForm').addEventListener('submit', function(e) {
            e.preventDefault();
            if (this.checkValidity()) {
                alert('Thank you for contacting BCI. Your secure message has been received. We will respond within 24 hours.');
                this.reset();
            }
            this.classList.add('was-validated');
        });
    </script>
</body>
</html>