<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cyber Threats Intelligence - Bureau of Cybercrime Intelligence</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="css/styles.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-custom fixed-top">
        <div class="container">
            <a class="navbar-brand navbar-brand-custom d-flex align-items-center" href="index">
                <span class="logo-accent me-3"><img src="images/logo.png" alt="BCI LOGO" width="80" height="80"></span>
                <h3 class="mb-0">Bureau of Cybercrime <br>Intelligence</h3>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon text-white"><i class="bi bi-list"></i></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="index">Home</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="services">Services</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="about">About</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom active" href="cyber-threats">Cyber Threats</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="contact">Contact</a></li>
                    <li class="nav-item ms-2">
                        <a href="report-cybercrime" class="btn btn-report-nav">
                            <i class="bi bi-exclamation-triangle-fill me-1"></i> Report CyberCrime
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="page-hero">
        <div class="container text-center">
            <h1>Cyber Threat Intelligence</h1>
            <p>Real-time analysis of evolving cybercrime tactics and threat actors</p>
        </div>
    </section>

    <!-- Threat Alert Banner -->
    <section class="threat-alert-banner">
        <div class="container">
            <div class="alert-content">
                <i class="bi bi-exclamation-triangle-fill"></i>
                <div>
                    <strong>CURRENT THREAT LEVEL: ELEVATED</strong>
                    <p>Increased ransomware activity detected targeting financial institutions - January 2026</p>
                </div>
                <a href="report-cybercrime" class="btn btn-warning">Report Incident</a>
            </div>
        </div>
    </section>

    <!-- Threat Categories -->
    <section class="threats-detail-section">
        <div class="container">
            <h2 class="section-title text-center mb-5">Major Threat Categories</h2>
            
            <div class="row g-4">
                    <!-- Ransomware -->
                    <div class="threat-detail-card">
                        <div class="threat-detail-header">
                            <i class="bi bi-bug-fill"></i>
                            <div>
                                <h3>Ransomware & Malware</h3>
                                <span class="threat-level critical">Critical Risk</span>
                            </div>
                        </div>
                        <div class="threat-detail-content">
                            <p class="threat-description">
                                Malicious software that encrypts victim data and demands payment for decryption. Modern ransomware often includes data exfiltration and double extortion tactics.
                            </p>
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <div class="threat-stat">
                                        <h4>$4.5M</h4>
                                        <p>average ransomware attack cost in 2025</p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="threat-stat">
                                        <h4>11 sec</h4>
                                        <p>frequency of ransomware attacks globally</p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="threat-stat">
                                        <h4>21 days</h4>
                                        <p>average downtime after attack</p>
                                    </div>
                                </div>
                            </div>
                            <div class="threat-actors mt-4">
                                <h5><i class="bi bi-people-fill me-2"></i>Active Threat Groups:</h5>
                                <div class="actor-grid">
                                    <div class="actor-tag">LockBit 3.0</div>
                                    <div class="actor-tag">BlackCat (ALPHV)</div>
                                    <div class="actor-tag">Royal Ransomware</div>
                                    <div class="actor-tag">Cl0p</div>
                                </div>
                            </div>
                            <div class="protection-tips mt-4">
                                <h5><i class="bi bi-shield-check me-2"></i>Protection Measures:</h5>
                                <ul>
                                    <li>Maintain offline, encrypted backups with 3-2-1 backup strategy</li>
                                    <li>Implement network segmentation and zero-trust architecture</li>
                                    <li>Deploy endpoint detection and response (EDR) solutions</li>
                                    <li>Patch systems and software regularly</li>
                                    <li>Establish incident response plan and conduct drills</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Phishing and Social Engineering -->
                    <div class="threat-detail-card">
                        <div class="threat-detail-header">
                            <i class="bi bi-envelope-exclamation-fill"></i>
                            <div>
                                <h3>Phishing & Social Engineering</h3>
                                <span class="threat-level high">High Risk</span>
                            </div>
                        </div>
                        <div class="threat-detail-content">
                            <p class="threat-description">
                                Sophisticated attacks using psychological manipulation to trick individuals into revealing sensitive information or performing actions that compromise security.
                            </p>
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <div class="threat-stat">
                                        <h4>78%</h4>
                                        <p>of data breaches start with phishing</p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="threat-stat">
                                        <h4>$2.4M</h4>
                                        <p>average loss per business email compromise</p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="threat-stat">
                                        <h4>300%</h4>
                                        <p>increase in phishing attacks since 2020</p>
                                    </div>
                                </div>
                            </div>
                            <div class="protection-tips mt-4">
                                <h5><i class="bi bi-shield-check me-2"></i>Protection Measures:</h5>
                                <ul>
                                    <li>Implement multi-factor authentication (MFA) across all systems</li>
                                    <li>Conduct regular security awareness training</li>
                                    <li>Deploy advanced email filtering and anti-phishing tools</li>
                                    <li>Verify sender identity before clicking links or attachments</li>
                                    <li>Report suspicious emails to your security team immediately</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                <!-- Data Breaches -->
                <div class="col-md-6">
                    <div class="threat-detail-card">
                        <div class="threat-detail-header">
                            <i class="bi bi-database-fill"></i>
                            <div>
                                <h3>Data Breaches & Exfiltration</h3>
                                <span class="threat-level high">High Risk</span>
                            </div>
                        </div>
                        <div class="threat-detail-content">
                            <p class="threat-description">
                                Unauthorized access and extraction of sensitive organizational or customer data, often leading to regulatory penalties, lawsuits, and reputational damage.
                            </p>
                            <div class="protection-tips mt-4">
                                <h5><i class="bi bi-shield-check me-2"></i>Protection Measures:</h5>
                                <ul>
                                    <li>Encrypt data at rest and in transit</li>
                                    <li>Implement data loss prevention (DLP) tools</li>
                                    <li>Monitor and audit data access patterns</li>
                                    <li>Apply least-privilege access controls</li>
                                    <li>Conduct regular penetration testing</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payment Fraud -->
                <div class="col-md-6">
                    <div class="threat-detail-card">
                        <div class="threat-detail-header">
                            <i class="bi bi-credit-card-fill"></i>
                            <div>
                                <h3>Payment & Financial Fraud</h3>
                                <span class="threat-level high">High Risk</span>
                            </div>
                        </div>
                        <div class="threat-detail-content">
                            <p class="threat-description">
                                Fraudulent financial transactions, card skimming, wire fraud, and business email compromise targeting payment systems and financial processes.
                            </p>
                            <div class="protection-tips mt-4">
                                <h5><i class="bi bi-shield-check me-2"></i>Protection Measures:</h5>
                                <ul>
                                    <li>Implement dual authorization for large transactions</li>
                                    <li>Use secure payment gateways with PCI-DSS compliance</li>
                                    <li>Monitor for unusual transaction patterns</li>
                                    <li>Verify payment requests through secondary channels</li>
                                    <li>Train finance staff on BEC tactics</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Account Takeover -->
                <div class="col-md-6">
                    <div class="threat-detail-card">
                        <div class="threat-detail-header">
                            <i class="bi bi-person-badge-fill"></i>
                            <div>
                                <h3>Account Takeover & Credential Theft</h3>
                                <span class="threat-level medium">Medium Risk</span>
                            </div>
                        </div>
                        <div class="threat-detail-content">
                            <p class="threat-description">
                                Unauthorized access to user accounts through stolen credentials, often obtained via phishing, data breaches, or credential stuffing attacks.
                            </p>
                            <div class="protection-tips mt-4">
                                <h5><i class="bi bi-shield-check me-2"></i>Protection Measures:</h5>
                                <ul>
                                    <li>Enforce strong password policies and MFA</li>
                                    <li>Monitor for credential leaks on dark web</li>
                                    <li>Implement account activity monitoring</li>
                                    <li>Use passwordless authentication where possible</li>
                                    <li>Deploy behavioral analytics to detect anomalies</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- DDoS Attacks -->
                <div class="col-md-6">
                    <div class="threat-detail-card">
                        <div class="threat-detail-header">
                            <i class="bi bi-shield-fill-exclamation"></i>
                            <div>
                                <h3>DDoS Attacks & Service Disruption</h3>
                                <span class="threat-level medium">Medium Risk</span>
                            </div>
                        </div>
                        <div class="threat-detail-content">
                            <p class="threat-description">
                                Distributed denial-of-service attacks that overwhelm systems with traffic, causing service outages and potential financial losses.
                            </p>
                            <div class="protection-tips mt-4">
                                <h5><i class="bi bi-shield-check me-2"></i>Protection Measures:</h5>
                                <ul>
                                    <li>Deploy DDoS mitigation services and CDN</li>
                                    <li>Implement rate limiting and traffic filtering</li>
                                    <li>Maintain redundant infrastructure</li>
                                    <li>Create incident response playbooks</li>
                                    <li>Monitor traffic patterns for anomalies</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Threat Intelligence Resources -->
    <section class="resources-section">
        <div class="container">
            <h2 class="section-title text-center mb-5">Intelligence Resources</h2>
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="resource-card">
                        <i class="bi bi-file-earmark-text-fill"></i>
                        <h4>Threat Reports</h4>
                        <p>Quarterly intelligence reports on emerging threats</p>
                        <a href="#" class="btn btn-outline-primary">Download Latest</a>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="resource-card">
                        <i class="bi bi-graph-up-arrow"></i>
                        <h4>Threat Dashboard</h4>
                        <p>Real-time threat monitoring and analytics</p>
                        <a href="#" class="btn btn-outline-primary">Access Dashboard</a>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="resource-card">
                        <i class="bi bi-bell-fill"></i>
                        <h4>Alert Subscriptions</h4>
                        <p>Get notified of critical threat updates</p>
                        <a href="#" class="btn btn-outline-primary">Subscribe</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center">
            <h2 class="cta-title">Under Attack?</h2>
            <p class="mb-4" style="opacity: 1; color: white;">Our 24/7 incident response team is standing by</p>
            <a href="report-cybercrime" class="btn btn-cta">
                <i class="bi bi-exclamation-triangle-fill me-2"></i> Report Cyber Incident
            </a>
        </div>
    </section>
 <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row g-4">
                <!-- Logo and Description -->
                <div class="col-lg-4">
                    <div class="footer-brand d-flex align-items-center mb-4">
                        <a  href="index" class="logo-accent me-3">
                            <img src="images/logo.png" alt="BCI LOGO" width="80" height="80">
                        </a>
                        <div>
                            <h4 class="mb-1 fw-bold text-white">BUREAU OF</h4>
                            <h4 class="mb-0 fw-bold text-white">CYBERCRIME INTELLIGENCE</h4>
                        </div>
                    </div>
                    <p class="text-light mb-4" style="opacity: 0.8;">
                        Defending Digital Intelligence through advanced cybercrime investigation and prevention.
                    </p>
                    <div class="social-links d-flex gap-3">
                        <a href="#" class="social-icon"><i class="bi bi-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-linkedin"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-facebook"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-youtube"></i></a>
                    </div>
                </div>
                
                <!-- Quick Links -->
                <div class="col-lg-2 col-md-6">
                    <h5 class="footer-heading">Quick Links</h5>
                    <ul class="footer-links">
                        <li><a href="index"><i class="bi bi-house-door me-2"></i> Home</a></li>
                        <li><a href="services"><i class="bi bi-gear me-2"></i> Services</a></li>
                        <li><a href="about"><i class="bi bi-info-circle me-2"></i> About</a></li>
                        <li><a href="cyber-threats"><i class="bi bi-shield-exclamation me-2"></i> Cyber Threats</a></li>
                        <li><a href="contact"><i class="bi bi-envelope me-2"></i> Contact</a></li>
                    </ul>
                </div>
                
                <!-- Contact Information -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-heading">Contact Information</h5>
                    <div class="contact-info">
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-telephone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">General Inquiries</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4711</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-phone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Emergency Hotline</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4712</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-envelope-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Email Address</h6>
                                <p class="mb-0 text-light">cybercrimeintelbureau@gmail.com</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start">
                            <i class="bi bi-clock-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Operating Hours</h6>
                                <p class="mb-0 text-light">24/7 Emergency Response</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Newsletter & Emergency -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-heading">Stay Updated</h5>
                    <div class="newsletter mb-4">
                        <p class="text-light mb-3" style="opacity: 0.8;">
                            Subscribe to our threat intelligence newsletter
                        </p>
                        <div class="input-group">
                            <input type="email" class="form-control" placeholder="Your email">
                            <button class="btn btn-warning" type="button">
                                <i class="bi bi-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="emergency-card bg-dark border border-warning rounded p-3">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-exclamation-triangle-fill text-warning fs-4 me-2"></i>
                            <h6 class="mb-0 text-white">Emergency Contact</h6>
                        </div>
                        <p class="text-light small mb-3">For immediate cyber incident response</p>
                        <a href="report-cybercrime" class="btn btn-warning w-100">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i> Report Emergency
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Footer Bottom -->
            <div class="footer-bottom mt-5 pt-4 border-top border-secondary">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <p class="mb-2 mb-md-0 text-light" style="opacity: 0.7;">
                            &copy; 2026 Bureau of Cybercrime Intelligence. All rights reserved.
                        </p>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <div class="footer-bottom-links">
                            <a href="privacy-policy" class="text-light me-3" style="opacity: 0.7;">Privacy Policy</a>
                            <a href="terms-of-service" class="text-light me-3" style="opacity: 0.7;">Terms of Service</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Back to Top Button -->
    <button id="backToTop" class="btn-back-to-top">
        <i class="bi bi-chevron-up"></i>
    </button>

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script src="js/main.js"></script>
    
    <script>
        // Back to Top Button
        const backToTopButton = document.getElementById('backToTop');

        window.addEventListener('scroll', function() {
            if (window.scrollY > 300) {
                backToTopButton.classList.add('visible');
            } else {
                backToTopButton.classList.remove('visible');
            }
        });

        backToTopButton.addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });

        // Animated counters for stats
        const animateCounter = (element) => {
            const target = parseInt(element.getAttribute('data-target'));
            const duration = 2000;
            const increment = target / (duration / 16);
            let current = 0;
            
            const timer = setInterval(() => {
                current += increment;
                if (current >= target) {
                    element.textContent = target;
                    clearInterval(timer);
                } else {
                    element.textContent = Math.floor(current);
                }
            }, 16);
        };

        // Add active class to current page in navigation
        document.addEventListener('DOMContentLoaded', function() {
            const currentPage = window.location.pathname.split('/').pop() || 'cyber-threats.php';
            const navLinks = document.querySelectorAll('.nav-link-custom');
            
            navLinks.forEach(link => {
                const linkPage = link.getAttribute('href');
                if (linkPage === currentPage || 
                    (currentPage === '' && linkPage === 'cyber-threats') ||
                    (currentPage === 'cyber-threats.php' && linkPage === 'cyber-threats')) {
                    link.classList.add('active');
                }
            });
            
            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    const targetId = this.getAttribute('href');
                    if (targetId === '#') return;
                    
                    const targetElement = document.querySelector(targetId);
                    if (targetElement) {
                        window.scrollTo({
                            top: targetElement.offsetTop - 80,
                            behavior: 'smooth'
                        });
                    }
                });
            });
            
            // Navbar background on scroll
            window.addEventListener('scroll', function() {
                const navbar = document.querySelector('.navbar-custom');
                if (window.scrollY > 50) {
                    navbar.style.backgroundColor = 'rgba(19, 27, 48, 0.95)';
                    navbar.style.backdropFilter = 'blur(10px)';
                } else {
                    navbar.style.backgroundColor = '';
                    navbar.style.backdropFilter = '';
                }
            });
        });
    </script>
</body>
</html>
