<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Our Services - Bureau of Cybercrime Intelligence</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/styles.css">
    <style>
        
        
        
    </style>
</head>
<body>
    <!-- Navigation (Same as index page) -->
    <nav class="navbar navbar-expand-lg navbar-custom fixed-top">
        <div class="container">
            <a class="navbar-brand navbar-brand-custom d-flex align-items-center" href="index">
                <span class="logo-accent me-3"><img src="images/logo.png" alt="BCI LOGO" width="80" height="80"></span>
                <h3 class="mb-0">Bureau of Cybercrime <br>Intelligence</h3>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon text-white">
                    <i class="bi bi-list"></i>
                </span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="index">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom active" href="services">Services</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="about">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="cyber-threats">Cyber Threats</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link nav-link-custom" href="contact">Contact</a>
                    </li>
                    <li class="nav-item ms-2">
                        <a href="report-cybercrime" class="btn btn-report-nav">
                            <i class="bi bi-exclamation-triangle-fill me-1"></i> Report CyberCrime
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="page-hero">
        <div class="container text-center">
            <h1>Our Services</h1>
            <p>Comprehensive cybercrime solutions to protect your digital assets</p>
        </div>
    </section>

    <!-- Services Detail Section -->
    <section class="service-detail-section">
        <div class="container">
            <!-- Incident Response -->
            <div class="service-detail-card">
                <div class="service-detail-header">
                    <i class="bi bi-lightning-charge-fill"></i>
                    <h2>Incident Response</h2>
                </div>
                <div class="service-detail-content">
                            <p>We isolate threats fast, stop the bleed, and get you back online safely. BCI coordinates technical, legal, and executive workstreams so decisions are clear and timelines are tight.</p>
                    
                    <h3>What you get:</h3>
                    <div class="features-grid">
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Containment plan</span>
                        </div>
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Eradication steps</span>
                        </div>
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Recovery checklist</span>
                        </div>
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>IOCs and timeline</span>
                        </div>
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Executive brief</span>
                        </div>
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Post-incident report</span>
                        </div>
                    </div>
                    
                    <h3>Our Process:</h3>
                    <ol class="process-list">
                        <li><strong>Initial Assessment:</strong> Rapid evaluation of the security incident</li>
                        <li><strong>Containment:</strong> Isolate affected systems to prevent further damage</li>
                        <li><strong>Investigation:</strong> Forensic analysis to identify root cause</li>
                        <li><strong>Eradication:</strong> Remove malicious components from systems</li>
                        <li><strong>Recovery:</strong> Restore systems to normal operation</li>
                        <li><strong>Post-Incident Analysis:</strong> Lessons learned and prevention strategies</li>
                    </ol>
                </div>
                <div class="service-detail-image mt-4">
                    <!-- <img src="https://images.unsplash.com/photo-1550751827-4bd374c3f58b?w=800&q=80" alt="Incident Response" class="img-fluid rounded"> -->
                    <img src="images/incident.avif" alt="Incident Response" class="img-fluid rounded">
                </div>
            </div>

            <!-- Digital Forensics -->
            <div class="service-detail-card">
                <div class="service-detail-header">
                    <i class="bi bi-search"></i>
                    <h2>Digital Forensics</h2>
                </div>
                <div class="service-detail-content">
                            <p>Court-ready evidence handling across endpoints, mobile, cloud, and network artifacts. Every action is logged and hash verified to protect chain of custody.</p>
                    
                    <h3>What you get:</h3>
                    <div class="features-grid">
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Acquisition images and hashes</span>
                        </div>
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Examination notes</span>
                        </div>
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Exhibit register</span>
                        </div>
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Findings report</span>
                        </div>
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Expert testimony on request</span>
                        </div>
                    </div>
                    
                    <h3>Forensic Capabilities:</h3>
                    <div class="capabilities-grid">
                        <div class="capability">
                            <i class="bi bi-pc-display"></i>
                            <h4>Computer Forensics</h4>
                            <p>Analysis of desktops, laptops, and servers</p>
                        </div>
                        <div class="capability">
                            <i class="bi bi-phone"></i>
                            <h4>Mobile Device Forensics</h4>
                            <p>iOS, Android, and other mobile platforms</p>
                        </div>
                        <div class="capability">
                            <i class="bi bi-cloud"></i>
                            <h4>Cloud Forensics</h4>
                            <p>AWS, Azure, Google Cloud investigations</p>
                        </div>
                        <div class="capability">
                            <i class="bi bi-diagram-3"></i>
                            <h4>Network Forensics</h4>
                            <p>Packet analysis and network traffic investigation</p>
                        </div>
                    </div>
                </div>
                <div class="service-detail-image mt-4">
                    <img src="https://images.unsplash.com/photo-1563986768609-322da13575f3?w=800&q=80" alt="Digital Forensics" class="img-fluid rounded">
                </div>
            </div>

            <!-- Threat Intelligence -->
            <div class="service-detail-card">
                <div class="service-detail-header">
                    <i class="bi bi-cpu-fill"></i>
                    <h2>Threat Intelligence</h2>
                </div>
                <div class="service-detail-content">
                            <p>Actionable intelligence built for defenders, not slide decks. We track actors, infrastructure, and TTPs and translate that into controls you can deploy.</p>
                    
                    <h3>What you get:</h3>
                    <div class="features-grid">
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Advisories</span>
                        </div>
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>STIX/TAXII feeds</span>
                        </div>
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Detection rules (Sigma, YARA, Suricata)</span>
                        </div>
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Takedown support</span>
                        </div>
                        <div class="feature-item">
                            <i class="bi bi-check-circle-fill"></i>
                            <span>Brand protection tips</span>
                        </div>
                    </div>
                    
                    <h3>Intelligence Products:</h3>
                    <div class="intelligence-grid">
                        <div class="intel-item">
                            <i class="bi bi-bell-fill"></i>
                            <h4>Daily Threat Briefs</h4>
                            <p>Daily updates on emerging threats and vulnerabilities</p>
                        </div>
                        <div class="intel-item">
                            <i class="bi bi-person-badge-fill"></i>
                            <h4>Threat Actor Profiles</h4>
                            <p>Detailed profiles of known cybercriminal groups</p>
                        </div>
                        <div class="intel-item">
                            <i class="bi bi-tools"></i>
                            <h4>Custom Detection Rules</h4>
                            <p>YARA and Sigma rules tailored to your environment</p>
                        </div>
                        <div class="intel-item">
                            <i class="bi bi-graph-up"></i>
                            <h4>Trend Analysis</h4>
                            <p>Quarterly reports on cybercrime trends and patterns</p>
                        </div>
                    </div>
                </div>
                <div class="service-detail-image mt-4">
                    <img src="https://images.unsplash.com/photo-1558494949-ef010cbdcc31?w=800&q=80" alt="Threat Intelligence" class="img-fluid rounded">
                </div>
            </div>
        </div>
    </section>

    <!-- Additional Services Section -->
    <section class="additional-services-section">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="additional-services-title">Additional Services</h2>
            </div>
            <div class="row g-4">
                <!-- Cyber Training -->
                <div class="col-lg-4 col-md-6">
                    <div class="additional-service-card">
                        <h3>Cyber Training</h3>
                        <p>Customized training programs for security teams, executives, and employees.</p>
                    </div>
                </div>

                <!-- Risk Assessment -->
                <div class="col-lg-4 col-md-6">
                    <div class="additional-service-card">
                        <h3>Risk Assessment</h3>
                        <p>Comprehensive security posture assessment and risk quantification.</p>
                    </div>
                </div>

                <!-- Compliance -->
                <div class="col-lg-4 col-md-6">
                    <div class="additional-service-card">
                        <h3>Compliance</h3>
                        <p>GDPR, HIPAA, PCI-DSS, and industry-specific compliance support.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center">
            <h2 class="cta-title">Ready to Secure Your Organization?</h2>
            <p class="mb-4" style="opacity: 1; color: white;">Contact us today to discuss your cybersecurity needs</p>
            <a href="contact" class="btn btn-cta">
                <i class="bi bi-person-plus-fill me-2"></i> Contact Us
            </a>
        </div>
    </section>
 <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row g-4">
                <!-- Logo and Description -->
                <div class="col-lg-4">
                    <div class="footer-brand d-flex align-items-center mb-4">
                        <a  href="index" class="logo-accent me-3">
                            <img src="images/logo.png" alt="BCI LOGO" width="80" height="80">
                        </a>
                        <div>
                            <h4 class="mb-1 fw-bold text-white">BUREAU OF</h4>
                            <h4 class="mb-0 fw-bold text-white">CYBERCRIME INTELLIGENCE</h4>
                        </div>
                    </div>
                    <p class="text-light mb-4" style="opacity: 0.8;">
                        Defending Digital Intelligence through advanced cybercrime investigation and prevention.
                    </p>
                    <div class="social-links d-flex gap-3">
                        <a href="#" class="social-icon"><i class="bi bi-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-linkedin"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-facebook"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-youtube"></i></a>
                    </div>
                </div>
                
                <!-- Quick Links -->
                <div class="col-lg-2 col-md-6">
                    <h5 class="footer-heading">Quick Links</h5>
                    <ul class="footer-links">
                        <li><a href="index"><i class="bi bi-house-door me-2"></i> Home</a></li>
                        <li><a href="services"><i class="bi bi-gear me-2"></i> Services</a></li>
                        <li><a href="about"><i class="bi bi-info-circle me-2"></i> About</a></li>
                        <li><a href="cyber-threats"><i class="bi bi-shield-exclamation me-2"></i> Cyber Threats</a></li>
                        <li><a href="contact"><i class="bi bi-envelope me-2"></i> Contact</a></li>
                    </ul>
                </div>
                
                <!-- Contact Information -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-heading">Contact Information</h5>
                    <div class="contact-info">
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-telephone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">General Inquiries</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4711</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-phone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Emergency Hotline</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4712</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-envelope-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Email Address</h6>
                                <p class="mb-0 text-light">cybercrimeintelbureau@gmail.com</p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start">
                            <i class="bi bi-clock-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Operating Hours</h6>
                                <p class="mb-0 text-light">24/7 Emergency Response</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Newsletter & Emergency -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="footer-heading">Stay Updated</h5>
                    <div class="newsletter mb-4">
                        <p class="text-light mb-3" style="opacity: 0.8;">
                            Subscribe to our threat intelligence newsletter
                        </p>
                        <div class="input-group">
                            <input type="email" class="form-control" placeholder="Your email">
                            <button class="btn btn-warning" type="button">
                                <i class="bi bi-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="emergency-card bg-dark border border-warning rounded p-3">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-exclamation-triangle-fill text-warning fs-4 me-2"></i>
                            <h6 class="mb-0 text-white">Emergency Contact</h6>
                        </div>
                        <p class="text-light small mb-3">For immediate cyber incident response</p>
                        <a href="report-cybercrime" class="btn btn-warning w-100">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i> Report Emergency
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Footer Bottom -->
            <div class="footer-bottom mt-5 pt-4 border-top border-secondary">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <p class="mb-2 mb-md-0 text-light" style="opacity: 0.7;">
                            &copy; 2026 Bureau of Cybercrime Intelligence. All rights reserved.
                        </p>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <div class="footer-bottom-links">
                            <a href="privacy-policy" class="text-light me-3" style="opacity: 0.7;">Privacy Policy</a>
                            <a href="terms-of-service" class="text-light me-3" style="opacity: 0.7;">Terms of Service</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Back to Top Button -->
    <button id="backToTop" class="btn-back-to-top">
        <i class="bi bi-chevron-up"></i>
    </button>

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script src="js/main.js"></script>
    
    <script>
        // Back to Top Button
        const backToTopButton = document.getElementById('backToTop');

        window.addEventListener('scroll', function() {
            if (window.scrollY > 300) {
                backToTopButton.classList.add('visible');
            } else {
                backToTopButton.classList.remove('visible');
            }
        });

        backToTopButton.addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });

        // Animated counters for stats
        const animateCounter = (element) => {
            const target = parseInt(element.getAttribute('data-target'));
            const duration = 2000;
            const increment = target / (duration / 16);
            let current = 0;
            
            const timer = setInterval(() => {
                current += increment;
                if (current >= target) {
                    element.textContent = target;
                    clearInterval(timer);
                } else {
                    element.textContent = Math.floor(current);
                }
            }, 16);
        };

        // Add active class to current page in navigation
        document.addEventListener('DOMContentLoaded', function() {
            const currentPage = window.location.pathname.split('/').pop() || 'services.php';
            const navLinks = document.querySelectorAll('.nav-link-custom');
            
            navLinks.forEach(link => {
                const linkPage = link.getAttribute('href');
                if (linkPage === currentPage || 
                    (currentPage === '' && linkPage === 'services') ||
                    (currentPage === 'services.php' && linkPage === 'services')) {
                    link.classList.add('active');
                }
            });
            
            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    const targetId = this.getAttribute('href');
                    if (targetId === '#') return;
                    
                    const targetElement = document.querySelector(targetId);
                    if (targetElement) {
                        window.scrollTo({
                            top: targetElement.offsetTop - 80,
                            behavior: 'smooth'
                        });
                    }
                });
            });
            
            // Navbar background on scroll
            window.addEventListener('scroll', function() {
                const navbar = document.querySelector('.navbar-custom');
                if (window.scrollY > 50) {
                    navbar.style.backgroundColor = 'rgba(19, 27, 48, 0.95)';
                    navbar.style.backdropFilter = 'blur(10px)';
                } else {
                    navbar.style.backgroundColor = '';
                    navbar.style.backdropFilter = '';
                }
            });
        });
    </script>
</body>
</html>
