<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Terms of Service - Bureau of Cybercrime Intelligence</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="css/styles.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-custom fixed-top">
        <div class="container">
            <a class="navbar-brand navbar-brand-custom d-flex align-items-center" href="index">
                <span class="logo-accent me-3"><img src="images/logo.png" alt="BCI LOGO" width="80" height="80"></span>
                <h3 class="mb-0">Bureau of Cybercrime <br>Intelligence</h3>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon text-white"><i class="bi bi-list"></i></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="index">Home</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="services">Services</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="about">About</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="cyber-threats">Cyber Threats</a></li>
                    <li class="nav-item"><a class="nav-link nav-link-custom" href="contact">Contact</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <section class="page-hero">
        <div class="container text-center">
            <h1>Terms of Service</h1>
            <p>Legal agreement governing the use of BCI services</p>
            <p class="small">Effective Date: October 9, 2025</p>
        </div>
    </section>

    <section class="legal-content-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="legal-card">
                        <div class="legal-toc">
                            <h5>Table of Contents</h5>
                            <ul>
                                <li><a href="#section1">Acceptance of Terms</a></li>
                                <li><a href="#section2">Services Description</a></li>
                                <li><a href="#section3">User Obligations</a></li>
                                <li><a href="#section4">Confidentiality and Non-Disclosure</a></li>
                                <li><a href="#section5">Intellectual Property</a></li>
                                <li><a href="#section6">Fees and Payment</a></li>
                                <li><a href="#section7">Limitation of Liability</a></li>
                                <li><a href="#section8">Indemnification</a></li>
                                <li><a href="#section9">Termination</a></li>
                                <li><a href="#section10">Dispute Resolution</a></li>
                                <li><a href="#section11">Governing Law</a></li>
                                <li><a href="#section12">General Provisions</a></li>
                            </ul>
                        </div>

                        <div class="legal-intro">
                            <p class="alert alert-info"><i class="bi bi-info-circle-fill me-2"></i>
                            <strong>IMPORTANT:</strong> Please read these Terms of Service carefully before using BCI services. By accessing or using our services, you agree to be bound by these terms.</p>
                        </div>

                        <div class="legal-section" id="section1">
                            <h3>1. Acceptance of Terms</h3>
                            <p>These Terms of Service ("Terms") constitute a legally binding agreement between you ("Client," "you," or "your") and the Bureau of Cybercrime Intelligence ("BCI," "we," "us," or "our"). By:</p>
                            <ul>
                                <li>Accessing our website (www.bci.com)</li>
                                <li>Engaging our services</li>
                                <li>Submitting incident reports</li>
                                <li>Communicating with BCI personnel</li>
                            </ul>
                            <p>You acknowledge that you have read, understood, and agree to be bound by these Terms and our Privacy Policy.</p>
                        </div>

                        <div class="legal-section" id="section2">
                            <h3>2. Services Description</h3>
                            <p>BCI provides comprehensive cybercrime intelligence and forensic investigation services, including but not limited to:</p>
                            
                            <h4>2.1 Core Services</h4>
                            <ul>
                                <li><strong>Incident Response:</strong> Emergency response to active cyber attacks and security breaches</li>
                                <li><strong>Digital Forensics:</strong> Court-admissible evidence collection and analysis</li>
                                <li><strong>Threat Intelligence:</strong> Actionable intelligence on threat actors and attack patterns</li>
                                <li><strong>Malware Analysis:</strong> Reverse engineering and behavioral analysis</li>
                                <li><strong>Cybercrime Investigation:</strong> Comprehensive investigation services</li>
                                <li><strong>Security Consulting:</strong> Advisory services for cybersecurity improvements</li>
                            </ul>

                            <h4>2.2 Service Availability</h4>
                            <p>While we strive for 24/7 availability, we do not guarantee uninterrupted service. Emergency response times vary based on incident severity and available resources.</p>
                        </div>

                        <div class="legal-section" id="section3">
                            <h3>3. User Obligations</h3>
                            
                            <h4>3.1 Accurate Information</h4>
                            <p>You agree to provide accurate, complete, and truthful information when engaging our services, including incident reports and evidence.</p>

                            <h4>3.2 Lawful Use</h4>
                            <p>You agree to use BCI services only for lawful purposes. You will not:</p>
                            <ul>
                                <li>Engage in illegal activities or use our services to facilitate crimes</li>
                                <li>Provide false or misleading information</li>
                                <li>Interfere with our operations or security measures</li>
                                <li>Attempt to gain unauthorized access to our systems</li>
                                <li>Use our services to harm others or violate their rights</li>
                            </ul>

                            <h4>3.3 Cooperation</h4>
                            <p>You agree to cooperate with BCI personnel during investigations, including:</p>
                            <ul>
                                <li>Providing timely access to affected systems and evidence</li>
                                <li>Responding to information requests promptly</li>
                                <li>Following recommended security protocols</li>
                                <li>Preserving evidence as instructed</li>
                            </ul>
                        </div>

                        <div class="legal-section" id="section4">
                            <h3>4. Confidentiality and Non-Disclosure</h3>
                            
                            <h4>4.1 BCI Confidentiality Obligations</h4>
                            <p>BCI maintains strict confidentiality regarding:</p>
                            <ul>
                                <li>Client identity and organizational information</li>
                                <li>Incident details and investigation findings</li>
                                <li>Evidence and technical artifacts</li>
                                <li>Communications and reports</li>
                            </ul>

                            <h4>4.2 Exceptions to Confidentiality</h4>
                            <p>BCI may disclose confidential information when:</p>
                            <ul>
                                <li>Required by law, court order, or regulatory authority</li>
                                <li>Necessary for law enforcement cooperation</li>
                                <li>Client provides explicit written consent</li>
                                <li>Required to protect BCI's legal rights</li>
                                <li>Necessary to prevent imminent harm</li>
                            </ul>

                            <h4>4.3 Client Obligations</h4>
                            <p>Clients agree to maintain confidentiality regarding:</p>
                            <ul>
                                <li>BCI's methodologies and techniques</li>
                                <li>Investigation strategies and findings</li>
                                <li>Proprietary tools and technologies</li>
                            </ul>
                        </div>

                        <div class="legal-section" id="section5">
                            <h3>5. Intellectual Property</h3>
                            
                            <h4>5.1 BCI Property</h4>
                            <p>All content, tools, methodologies, reports, and materials developed by BCI remain our exclusive intellectual property. This includes:</p>
                            <ul>
                                <li>Investigation methodologies and techniques</li>
                                <li>Analysis tools and software</li>
                                <li>Report formats and templates</li>
                                <li>Training materials and documentation</li>
                            </ul>

                            <h4>5.2 Client Data</h4>
                            <p>Client retains ownership of their data and evidence. BCI receives a limited license to use such materials solely for providing contracted services.</p>

                            <h4>5.3 Report Usage</h4>
                            <p>Clients may use investigation reports for internal purposes and legal proceedings but may not publicly distribute BCI methodologies without written permission.</p>
                        </div>

                        <div class="legal-section" id="section6">
                            <h3>6. Fees and Payment</h3>
                            
                            <h4>6.1 Service Fees</h4>
                            <p>Fees are determined based on:</p>
                            <ul>
                                <li>Service type and complexity</li>
                                <li>Required resources and expertise</li>
                                <li>Urgency and response time requirements</li>
                                <li>Duration of engagement</li>
                            </ul>

                            <h4>6.2 Payment Terms</h4>
                            <ul>
                                <li>Emergency response may require immediate payment authorization</li>
                                <li>Retainer agreements available for ongoing services</li>
                                <li>Invoices due within 30 days unless otherwise specified</li>
                                <li>Late payments subject to interest charges</li>
                            </ul>

                            <h4>6.3 Expenses</h4>
                            <p>Client responsible for reimbursing reasonable expenses including travel, specialized software, and third-party services.</p>
                        </div>

                        <div class="legal-section" id="section7">
                            <h3>7. Limitation of Liability</h3>
                            <p class="alert alert-warning"><strong>IMPORTANT:</strong> Please read this section carefully as it limits BCI's liability.</p>
                            
                            <h4>7.1 Service Limitations</h4>
                            <p>BCI provides professional services based on industry standards but cannot guarantee specific outcomes. We do not warrant that:</p>
                            <ul>
                                <li>All evidence will be recoverable</li>
                                <li>Perpetrators will be identified</li>
                                <li>Systems can be fully restored</li>
                                <li>Future attacks will be prevented</li>
                            </ul>

                            <h4>7.2 Liability Cap</h4>
                            <p>TO THE MAXIMUM EXTENT PERMITTED BY LAW, BCI'S TOTAL LIABILITY SHALL NOT EXCEED THE FEES PAID FOR THE SPECIFIC SERVICE GIVING RISE TO THE CLAIM.</p>

                            <h4>7.3 Excluded Damages</h4>
                            <p>BCI SHALL NOT BE LIABLE FOR INDIRECT, INCIDENTAL, CONSEQUENTIAL, SPECIAL, OR PUNITIVE DAMAGES, INCLUDING LOST PROFITS, BUSINESS INTERRUPTION, OR DATA LOSS.</p>
                        </div>

                        <div class="legal-section" id="section8">
                            <h3>8. Indemnification</h3>
                            <p>Client agrees to indemnify, defend, and hold harmless BCI from claims, damages, or expenses arising from:</p>
                            <ul>
                                <li>Client's breach of these Terms</li>
                                <li>Client's illegal activities or violations of third-party rights</li>
                                <li>Inaccurate or misleading information provided by Client</li>
                                <li>Client's failure to follow BCI recommendations</li>
                            </ul>
                        </div>

                        <div class="legal-section" id="section9">
                            <h3>9. Termination</h3>
                            
                            <h4>9.1 By Client</h4>
                            <p>Client may terminate services with written notice, subject to payment for services rendered.</p>

                            <h4>9.2 By BCI</h4>
                            <p>BCI may terminate services if:</p>
                            <ul>
                                <li>Client breaches these Terms</li>
                                <li>Payment obligations are not met</li>
                                <li>Client engages in illegal activities</li>
                                <li>Continuing services would violate law or ethics</li>
                            </ul>

                            <h4>9.3 Effect of Termination</h4>
                            <p>Upon termination:</p>
                            <ul>
                                <li>Client must pay all outstanding fees</li>
                                <li>Confidentiality obligations continue</li>
                                <li>BCI will return or destroy Client data as requested</li>
                                <li>Licenses to BCI intellectual property terminate</li>
                            </ul>
                        </div>

                        <div class="legal-section" id="section10">
                            <h3>10. Dispute Resolution</h3>
                            
                            <h4>10.1 Negotiation</h4>
                            <p>Parties agree to first attempt good-faith negotiation to resolve disputes.</p>

                            <h4>10.2 Mediation</h4>
                            <p>If negotiation fails, parties agree to mediation before pursuing litigation.</p>

                            <h4>10.3 Arbitration</h4>
                            <p>Disputes not resolved through mediation shall be submitted to binding arbitration under the rules of the International Chamber of Commerce.</p>
                        </div>

                        <div class="legal-section" id="section11">
                            <h3>11. Governing Law</h3>
                            <p>These Terms are governed by the laws of Liberia, without regard to conflict of law principles. Jurisdiction for legal proceedings lies with the courts of Monrovia, Liberia.</p>
                        </div>

                        <div class="legal-section" id="section12">
                            <h3>12. General Provisions</h3>
                            
                            <h4>12.1 Entire Agreement</h4>
                            <p>These Terms, together with our Privacy Policy and any service-specific agreements, constitute the entire agreement between parties.</p>

                            <h4>12.2 Amendments</h4>
                            <p>BCI may modify these Terms with notice. Continued use of services constitutes acceptance of modifications.</p>

                            <h4>12.3 Severability</h4>
                            <p>If any provision is found unenforceable, remaining provisions remain in full effect.</p>

                            <h4>12.4 Waiver</h4>
                            <p>Failure to enforce any provision does not constitute waiver of that provision.</p>

                            <h4>12.5 Assignment</h4>
                            <p>Client may not assign these Terms without BCI's written consent.</p>

                            <h4>12.6 Force Majeure</h4>
                            <p>BCI is not liable for delays or failures due to circumstances beyond reasonable control.</p>
                        </div>

                        <div class="legal-section">
                            <h3>Contact Information</h3>
                            <div class="contact-box">
                                <p><strong>Bureau of Cybercrime Intelligence</strong><br>
                                Legal Department<br>
                                123 Cyber Security Boulevard<br>
                                Intelligence District, Monrovia, Liberia</p>
                                <p><strong>Email:</strong> <a href="mailto:legal@bci.com">legal@bci.com</a><br>
                                <strong>Phone:</strong> +231 (90) 909 4711</p>
                            </div>
                        </div>

                        <div class="legal-footer">
                            <p class="text-muted small">By engaging BCI services, you acknowledge that you have read, understood, and agree to these Terms of Service.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <div class="row g-4">
                <!-- Logo and Description -->
                <div class="col-lg-4">
                    <div class="footer-brand d-flex align-items-center mb-4">
                        <a href="index" class="logo-accent me-3">
                            <img src="images/logo.png" alt="BCI LOGO" width="80" height="80">
                        </a>
                        <div>
                            <h4 class="mb-1 fw-bold text-white">BUREAU OF</h4>
                            <h4 class="mb-0 fw-bold text-white">CYBERCRIME INTELLIGENCE</h4>
                        </div>
                    </div>
                    <p class="text-light mb-4" style="opacity: 0.8;">
                        Defending Digital Intelligence through advanced cybercrime investigation and prevention.
                    </p>
                </div>
                
                <!-- Quick Links -->
                <div class="col-lg-4 col-md-6">
                    <h5 class="footer-heading">Quick Links</h5>
                    <ul class="footer-links">
                        <li><a href="index"><i class="bi bi-house-door me-2"></i> Home</a></li>
                        <li><a href="report-cybercrime"><i class="bi bi-exclamation-triangle me-2"></i> Report Cybercrime</a></li>
                        <li><a href="privacy-policy"><i class="bi bi-file-text me-2"></i> Privacy Policy</a></li>
                        <li><a href="terms-of-service"><i class="bi bi-file-text me-2"></i> Terms of Service</a></li>
                    </ul>
                </div>
                
                <!-- Contact Information -->
                <div class="col-lg-4 col-md-6">
                    <h5 class="footer-heading">Contact Information</h5>
                    <div class="contact-info">
                        <div class="contact-item d-flex align-items-start mb-3">
                            <i class="bi bi-envelope-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Legal Department</h6>
                                <p class="mb-0 text-light"><a href="mailto:legal@bci.gov" style="color: inherit; text-decoration: none;">legal@bci.gov</a></p>
                            </div>
                        </div>
                        <div class="contact-item d-flex align-items-start">
                            <i class="bi bi-telephone-fill text-warning mt-1 me-3"></i>
                            <div>
                                <h6 class="mb-1 text-white">Phone</h6>
                                <p class="mb-0 text-light">+231 (90) 909 4711</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Footer Bottom -->
            <div class="footer-bottom mt-5 pt-4 border-top border-secondary">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <p class="mb-2 mb-md-0 text-light" style="opacity: 0.7;">
                            &copy; 2026 Bureau of Cybercrime Intelligence. All rights reserved.
                        </p>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <div class="footer-bottom-links">
                            <a href="privacy-policy" class="text-light me-3" style="opacity: 0.7;">Privacy Policy</a>
                            <a href="terms-of-service" class="text-light me-3" style="opacity: 0.7;">Terms of Service</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <button id="backToTop" class="btn-back-to-top">
        <i class="bi bi-chevron-up"></i>
    </button>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="js/main.js"></script>
</body>
</html>